//////////////////////////////////////////////////////////////////////
// This file is part of Remere's Map Editor
//////////////////////////////////////////////////////////////////////
// Remere's Map Editor is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Remere's Map Editor is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//////////////////////////////////////////////////////////////////////

#include "main.h"

#include "ground_brush.h"
#include "wall_brush.h"
#include "carpet_brush.h"
#include "table_brush.h"

//=============================================================================
// Border lookup tables

void GroundBrush::init() {
	GroundBrush::border_types[0] // 0
		= BORDER_NONE;
	GroundBrush::border_types[TILE_NORTHWEST] // 1
		= NORTHWEST_CORNER;
	GroundBrush::border_types[TILE_NORTH] // 10
		= NORTH_HORIZONTAL;
	GroundBrush::border_types[TILE_NORTH | TILE_NORTHWEST] // 11
		= NORTH_HORIZONTAL;
	GroundBrush::border_types[TILE_NORTHEAST] // 100
		= NORTHEAST_CORNER;
	GroundBrush::border_types[TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= NORTHWEST_CORNER | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_NORTHEAST | TILE_NORTH] // 110
		= NORTH_HORIZONTAL;
	GroundBrush::border_types[TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= NORTH_HORIZONTAL;
	GroundBrush::border_types[TILE_WEST] // 1000
		= WEST_HORIZONTAL;
	GroundBrush::border_types[TILE_WEST | TILE_NORTHWEST] // 1001
		= WEST_HORIZONTAL;
	GroundBrush::border_types[TILE_WEST | TILE_NORTH] // 1010
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_WEST | TILE_NORTHEAST] // 1100
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_EAST] // 10000
		= EAST_HORIZONTAL;
	GroundBrush::border_types[TILE_EAST | TILE_NORTHWEST] // 10001
		= NORTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_NORTH] // 10010
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_EAST | TILE_NORTHEAST] // 10100
		= EAST_HORIZONTAL;
	GroundBrush::border_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= NORTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_EAST | TILE_WEST] // 11000
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= NORTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= NORTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= NORTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= NORTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHWEST] // 100000
		= SOUTHWEST_CORNER;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= SOUTHWEST_CORNER | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTH] // 100010
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= SOUTHWEST_CORNER | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= SOUTHWEST_CORNER | NORTHEAST_CORNER << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST] // 101000
		= WEST_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= WEST_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= NORTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST] // 110000
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH] // 1000000
		= SOUTH_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTH] // 1000010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST] // 1001000
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST] // 1010000
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= SOUTH_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8 | NORTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;

	GroundBrush::border_types[TILE_SOUTHEAST]
		= SOUTHEAST_CORNER;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTHWEST] // 1
		= NORTHWEST_CORNER | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTH] // 10
		= NORTH_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11
		= NORTH_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTHEAST] // 100
		= NORTHEAST_CORNER | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= NORTHEAST_CORNER | NORTHWEST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH] // 110
		= NORTH_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= NORTH_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST] // 1000
		= WEST_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHWEST] // 1001
		= WEST_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH] // 1010
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST] // 1100
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST] // 10000
		= EAST_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHWEST] // 10001
		= EAST_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH] // 10010
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST] // 10100
		= EAST_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= EAST_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= NORTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST] // 11000
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= NORTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= EAST_HORIZONTAL | WEST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= NORTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= NORTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST] // 100000
		= SOUTHWEST_CORNER | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= SOUTHWEST_CORNER | NORTHWEST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH] // 100010
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= SOUTHWEST_CORNER | NORTHEAST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= SOUTHWEST_CORNER | NORTHEAST_CORNER << 8 | NORTHWEST_CORNER << 16 | SOUTHEAST_CORNER << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= SOUTHWEST_CORNER | NORTH_HORIZONTAL << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST] // 101000
		= WEST_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= WEST_HORIZONTAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= WEST_HORIZONTAL | NORTHEAST_CORNER << 8 | SOUTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= NORTHWEST_DIAGONAL | SOUTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST] // 110000
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= SOUTHWEST_CORNER | EAST_HORIZONTAL << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= SOUTHWEST_CORNER | NORTHEAST_DIAGONAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= WEST_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH] // 1000000
		= SOUTH_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH] // 1000010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8 | NORTHWEST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST] // 1001000
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST] // 1010000
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | EAST_HORIZONTAL << 16 | NORTH_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= SOUTH_HORIZONTAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= SOUTH_HORIZONTAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= SOUTH_HORIZONTAL | NORTHWEST_CORNER << 8 | NORTHEAST_CORNER << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= SOUTH_HORIZONTAL | NORTH_HORIZONTAL << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= SOUTHWEST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= SOUTHWEST_DIAGONAL | NORTHEAST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= SOUTH_HORIZONTAL | WEST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= SOUTHEAST_DIAGONAL;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= SOUTHEAST_DIAGONAL | NORTHWEST_CORNER << 8;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | WEST_HORIZONTAL << 16;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
	GroundBrush::border_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= SOUTH_HORIZONTAL | EAST_HORIZONTAL << 8 | NORTH_HORIZONTAL << 16 | WEST_HORIZONTAL << 24;
}

void WallBrush::init() {
	WallBrush::full_border_types[0] // 0
		= WALL_POLE;
	WallBrush::full_border_types[WALLTILE_NORTH] // 1
		= WALL_SOUTH_END;
	WallBrush::full_border_types[WALLTILE_WEST] // 10
		= WALL_EAST_END;
	WallBrush::full_border_types[WALLTILE_WEST | WALLTILE_NORTH] // 11
		= WALL_NORTHWEST_DIAGONAL;
	WallBrush::full_border_types[WALLTILE_EAST] // 100
		= WALL_WEST_END;
	WallBrush::full_border_types[WALLTILE_EAST | WALLTILE_NORTH] // 101
		= WALL_NORTHEAST_DIAGONAL;
	WallBrush::full_border_types[WALLTILE_EAST | WALLTILE_WEST] // 110
		= WALL_HORIZONTAL;
	WallBrush::full_border_types[WALLTILE_EAST | WALLTILE_WEST | WALLTILE_NORTH] // 111
		= WALL_SOUTH_T;
	WallBrush::full_border_types[WALLTILE_SOUTH] // 1000
		= WALL_NORTH_END;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_NORTH] // 1001
		= WALL_VERTICAL;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_WEST] // 1010
		= WALL_SOUTHWEST_DIAGONAL;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_WEST | WALLTILE_NORTH] // 1011
		= WALL_EAST_T;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_EAST] // 1100
		= WALL_SOUTHEAST_DIAGONAL;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_NORTH] // 1101
		= WALL_WEST_T;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_WEST] // 1110
		= WALL_NORTH_T;
	WallBrush::full_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_WEST | WALLTILE_NORTH] // 1111
		= WALL_INTERSECTION;

	WallBrush::half_border_types[0] // 0
		= WALL_POLE;
	WallBrush::half_border_types[WALLTILE_NORTH] // 1
		= WALL_VERTICAL;
	WallBrush::half_border_types[WALLTILE_WEST] // 10
		= WALL_HORIZONTAL;
	WallBrush::half_border_types[WALLTILE_WEST | WALLTILE_NORTH] // 11
		= WALL_NORTHWEST_DIAGONAL;
	WallBrush::half_border_types[WALLTILE_EAST] // 100
		= WALL_POLE;
	WallBrush::half_border_types[WALLTILE_EAST | WALLTILE_NORTH] // 101
		= WALL_VERTICAL;
	WallBrush::half_border_types[WALLTILE_EAST | WALLTILE_WEST] // 110
		= WALL_HORIZONTAL;
	WallBrush::half_border_types[WALLTILE_EAST | WALLTILE_WEST | WALLTILE_NORTH] // 111
		= WALL_NORTHWEST_DIAGONAL;
	WallBrush::half_border_types[WALLTILE_SOUTH] // 1000
		= WALL_POLE;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_NORTH] // 1001
		= WALL_VERTICAL;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_WEST] // 1010
		= WALL_HORIZONTAL;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_WEST | WALLTILE_NORTH] // 1011
		= WALL_NORTHWEST_DIAGONAL;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_EAST] // 1100
		= WALL_POLE;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_NORTH] // 1101
		= WALL_VERTICAL;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_WEST] // 1110
		= WALL_HORIZONTAL;
	WallBrush::half_border_types[WALLTILE_SOUTH | WALLTILE_EAST | WALLTILE_WEST | WALLTILE_NORTH] // 1111
		= WALL_NORTHWEST_DIAGONAL;
}

void TableBrush::init() {
	TableBrush::table_types[0] // 0
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTHWEST] // 1
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTH] // 10
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_NORTH | TILE_NORTHWEST] // 11
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTHEAST] // 100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTHEAST | TILE_NORTH] // 110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_WEST] // 1000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTHWEST] // 1001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTH] // 1010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTHEAST] // 1100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_EAST] // 10000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTHWEST] // 10001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTH] // 10010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTHEAST] // 10100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_EAST | TILE_WEST] // 11000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST] // 100000
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTH] // 100010
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST] // 101000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST] // 110000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH] // 1000000
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTH] // 1000010
		= TABLE_VERTICAL;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= TABLE_NORTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST] // 1001000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST] // 1010000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= TABLE_HORIZONTAL;

	TableBrush::table_types[TILE_SOUTHEAST]
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTHWEST] // 1
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTH] // 10
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTHEAST] // 100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH] // 110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST] // 1000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHWEST] // 1001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH] // 1010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST] // 1100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST] // 10000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHWEST] // 10001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH] // 10010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST] // 10100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST] // 11000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST] // 100000
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH] // 100010
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST] // 101000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST] // 110000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH] // 1000000
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH] // 1000010
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST] // 1001000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST] // 1010000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= TABLE_SOUTH_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= TABLE_ALONE;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= TABLE_EAST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= TABLE_WEST_END;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= TABLE_HORIZONTAL;
	TableBrush::table_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= TABLE_HORIZONTAL;
}

void CarpetBrush::init() {
	CarpetBrush::carpet_types[0] // 0
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_NORTHWEST] // 1
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_NORTH] // 10
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_NORTH | TILE_NORTHWEST] // 11
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_NORTHEAST] // 100
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_NORTHEAST | TILE_NORTH] // 110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_WEST] // 1000
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTHWEST] // 1001
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTH] // 1010
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTHEAST] // 1100
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST] // 10000
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTHWEST] // 10001
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTH] // 10010
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTHEAST] // 10100
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST] // 11000
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHWEST] // 100000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTH] // 100010
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST] // 101000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST] // 110000
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH] // 1000000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTH] // 1000010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= NORTH_HORIZONTAL;
	;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST] // 1001000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST] // 1010000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= NORTHWEST_DIAGONAL;

	CarpetBrush::carpet_types[TILE_SOUTHEAST]
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTHWEST] // 1
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTH] // 10
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTHEAST] // 100
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTHWEST] // 101
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH] // 110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST] // 1000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHWEST] // 1001
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH] // 1010
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST] // 1100
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1110
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST] // 10000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHWEST] // 10001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH] // 10010
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 10011
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST] // 10100
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 10101
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 10110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 10111
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST] // 11000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 11001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH] // 11010
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 11011
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 11100
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 11101
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 11110
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 11111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST] // 100000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHWEST] // 100001
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH] // 100010
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 100011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST] // 100100
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 100101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 100110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 100111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST] // 101000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 101001
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 101010
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 101011
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 101100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 101101
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 101110
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 101111
		= NORTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST] // 110000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 110001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 110010
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 110011
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 110100
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 110101
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 110110
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 110111
		= NORTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 111000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 111001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 111010
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 111011
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 111100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 111101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 111110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 111111
		= NORTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH] // 1000000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHWEST] // 1000001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH] // 1000010
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTH | TILE_NORTHWEST] // 1000011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST] // 1000100
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTHWEST] // 1000101
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH] // 1000110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1000111
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST] // 1001000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHWEST] // 1001001
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH] // 1001010
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1001011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST] // 1001100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1001101
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1001110
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1001111
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST] // 1010000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHWEST] // 1010001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH] // 1010010
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1010011
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST] // 1010100
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1010101
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1010110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1010111
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST] // 1011000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1011001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH] // 1011010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1011011
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1011100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1011101
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1011110
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1011111
		= NORTHEAST_DIAGONAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST] // 1100000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHWEST] // 1100001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH] // 1100010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTH | TILE_NORTHWEST] // 1100011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST] // 1100100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1100101
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH] // 1100110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1100111
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST] // 1101000
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHWEST] // 1101001
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH] // 1101010
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1101011
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST] // 1101100
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1101101
		= SOUTHWEST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1101110
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1101111
		= WEST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST] // 1110000
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHWEST] // 1110001
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH] // 1110010
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTH | TILE_NORTHWEST] // 1110011
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST] // 1110100
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTHWEST] // 1110101
		= SOUTHEAST_CORNER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH] // 1110110
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1110111
		= EAST_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST] // 1111000
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHWEST] // 1111001
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH] // 1111010
		= CARPET_CENTER;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTH | TILE_NORTHWEST] // 1111011
		= SOUTHWEST_DIAGONAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST] // 1111100
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTHWEST] // 1111101
		= SOUTH_HORIZONTAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH] // 1111110
		= SOUTHEAST_DIAGONAL;
	CarpetBrush::carpet_types[TILE_SOUTHEAST | TILE_SOUTH | TILE_SOUTHWEST | TILE_EAST | TILE_WEST | TILE_NORTHEAST | TILE_NORTH | TILE_NORTHWEST] // 1111111
		= CARPET_CENTER;
}
